/**
 * \file: grl_bitmap_decoder_conf.h
 *
 * \version: $Id: grl_bitmap_decoder_conf.h,v 1.1 2010/01/11 12:57:48 tkniep Exp $ 
 *
 * Configuration settings
 *
 * \component: SVG Bitmap Decoder (SVGBMPDEC)
 *
 * \author: T. Kniep (tkniep@de.adit-jv.com)
 *
 * \copyright: (c) 2009 ADIT Corporation
 *
 ***********************************************************************/
 
#ifndef GRL_BITMAP_DECODER_CONF_H
#define GRL_BITMAP_DECODER_CONF_H

#include "grl_bitmap_decoder_core.h"

/** Name of lock for protecting access to the global context counter */
#define GRL_BMPDEC_LCK_NM_CTX           "/ADSVGbc"

/** Name of lock for protecting a busy context against destruction */
#define GRL_BMPDEC_LCK_NM_BSY           "/ADSVGbb"

/** Name of decoding tasks */
#define GRL_BMPDEC_TSK_NM_DEC           "ADSVGbdc"

/** Name of decoding event flag */
#define GRL_BMPDEC_FLG_NM_DEC           "ADSVGbdc"

/** Length of resource names */
#define GRL_BMPDEC_DSNAME_LEN           (8)

/** Timeout when waiting for locks */
#define GRL_BMPDEC_LOCK_TMO             (5000)

/** Timeout when waiting for finishing a decoding queue. Should be increased if queue size is increased */
#define GRL_BMPDEC_FINISH_TMO           (10000)

/** Default value for decoding queue size. Only used if devconf setting unavailable */
#define GRL_BMPDEC_DEFAULT_QUEUE_SIZE   (16)

/** Minimum value for decoding queue size */
#define GRL_BMPDEC_MIN_QUEUE_SIZE   (1)

/** Maximum value for decoding queue size */
#define GRL_BMPDEC_MAX_QUEUE_SIZE   (255)

/** Default value for jpeg support flag. Only used if devconf setting unavailable */
#define GRL_BMPDEC_DEFAULT_USE_JPEG     (1)

/** Maximum value for jpeg support flag */
#define GRL_BMPDEC_MAX_USE_JPEG         (1)

/** Default value for png support flag. Only used if devconf setting unavailable */
#define GRL_BMPDEC_DEFAULT_USE_PNG      (1)

/** Maximum value for png support flag */
#define GRL_BMPDEC_MAX_USE_PNG          (1)

/** Default value for fgs support flag. Only used if devconf setting unavailable */
#define GRL_BMPDEC_DEFAULT_USE_FGS      (1)

/** Maximum value for fgs support flag */
#define GRL_BMPDEC_MAX_USE_FGS          (1)

/** Default value for png display gamma. Only used if devconf setting unavailable */
#define GRL_BMPDEC_DEFAULT_DISP_GAMMA   (220000000)

/** Default value for png file gamme. Only used if devconf setting unavailable */
#define GRL_BMPDEC_DEFAULT_FILE_GAMMA   (45454545)

/** Default value for decoding task priority */
#define GRL_BMPDEC_DEFAULT_TSK_PRIO     (100)

#ifdef GRL_BMPDEC_KERNEL_MODULE

/** Minimum value for decoding task priority */
# define GRL_BMPDEC_MIN_TSK_PRIO         (0)

/** Maximum value for decoding task priority */
# define GRL_BMPDEC_MAX_TSK_PRIO         (255)

#else /* GRL_BMPDEC_KERNEL_MODULE */

/** Minimum value for decoding task priority */
# define GRL_BMPDEC_MIN_TSK_PRIO         (1)

/** Maximum value for decoding task priority */
# define GRL_BMPDEC_MAX_TSK_PRIO         (140)

#endif /* GRL_BMPDEC_KERNEL_MODULE */

/** Default value for decoding task stacksize */
#define GRL_BMPDEC_DEFAULT_TSK_STKSZ    (2048)

/** Minimum value for decoding task stacksize */
#define GRL_BMPDEC_MIN_TSK_STKSZ        (512)

/** Maximum value for decoding task stacksize */
#define GRL_BMPDEC_MAX_TSK_STKSZ        (0x6400000)

/** Default value for maximum number of contexts */
#define GRL_BMPDEC_DEFAULT_CTX_MAX      (20)

/** Minimum value for maximum number of contexts */
#define GRL_BMPDEC_MIN_CTX_MAX          (1)

/** Maximum value for maximum number of contexts */
#define GRL_BMPDEC_MAX_CTX_MAX          (255)

/** internal conversion between RGB and BGR should donr */
#define GRL_BMPDEC_MIN_RGB_TO_BGR           (0)

/** internal conversion between RGB and BGR should donr */
#define GRL_BMPDEC_DEFAULT_RGB_TO_BGR           (0)

/** internal conversion between RGB and BGR should donr */
#define GRL_BMPDEC_MAX_RGB_TO_BGR           (1)

#endif /* GRL_BITMAP_DECODER_CONF_H */
